﻿var canvasAnimList = {};

var getFitWidth = function(width, height, maxWidth, maxHeight)
{
	if (width / maxWidth >= height / maxHeight)
	{
		return maxWidth;
	}
	else { return Math.floor(maxHeight * width / height); }
}

var getFitHeight = function(width, height, maxWidth, maxHeight)
{
	if (width / maxWidth < height / maxHeight)
	{
		return maxHeight;
	}
	else { return Math.floor(maxWidth * height / width); }
}

/*

frames :
[
	{
		stay(M) : 200 (ms),
		fade(M) : 100 (ms; in fadeout),
		src(M) : "./img/x.jpg"
	},
	 :
	 :
	
]

*/
							
var CanvasAnim = function(id, frames)
{
	this.id = id;
	this.frames = frames;
	this.jCanvas = $("#" + this.id);
	this.maxWidth = this.jCanvas.width();
	this.maxHeight = this.jCanvas.height();
	this.context = document.getElementById(this.id).getContext("2d");
	this.loading = this.frames.length;
	this.index = 0;
	this.time = 0;
	this.crossFade = false; // trueならstayモード
	this.fitWidth = this.longer;
	this.fitHeight = this.longer;

	this.start = function()
	{
		var index = this.index;
		var indexNext = (index == this.frames.length - 1) ? (0) : (index + 1);
		var img = this.frames[index].img;
		var imgNext = this.frames[indexNext].img;
		
		// TODO: div 0対策
		var alpha = 0;
		if (this.crossFade) alpha = this.time / this.frames[index].fade;
		
		// 描画
		
		// 現在のフレーム
		this.context.globalAlpha = 1.0;
		this.context.drawImage(img, 0, 0, this.fitWidth, this.fitHeight);
		
		// 次回のフレーム
		this.context.globalAlpha = alpha;
		this.context.drawImage(imgNext, 0, 0, this.fitWidth, this.fitHeight);
		
		this.time += 30;
		if (this.crossFade)
		{
			if (this.time >= this.frames[index].fade)
			{
				this.time = 0;
				this.index++;
				if (this.index >= this.frames.length) this.index = 0;
				this.crossFade = false;
			}
		}
		else
		{
			if (this.time >= this.frames[index].stay)
			{
				this.time = 0;
				this.crossFade = true;
			}
		}
	};
	
	for(var j = 0; j < this.frames.length; j++)
	{
		this.frames[j].img = new Image();
		this.frames[j].img.onload = (function (canvasAnim)
		{
			return function()
			{
				// ※ this = img
				canvasAnim.fitWidth = getFitWidth(this.width, this.height, canvasAnim.maxWidth, canvasAnim.maxHeight);
				canvasAnim.fitHeight = getFitHeight(this.width, this.height, canvasAnim.maxWidth, canvasAnim.maxHeight);
				
				// キャンバスの大きさをフィットサイズに更新する
				canvasAnim.jCanvas.attr("width", canvasAnim.fitWidth);
				canvasAnim.jCanvas.attr("height", canvasAnim.fitHeight);
				
				canvasAnim.loading--;
				if (canvasAnim.loading <= 0)
				{
					// アニメーション開始
					setInterval(function () { canvasAnim.start(); }, 30);
				}
			};
			
		})(this);
		this.frames[j].img.src = this.frames[j].src;
	}
};
